const int buttonPin = D0;
const int ledPin = D3;

bool isBlinking = false;
bool lastButtonState = HIGH;
unsigned long lastBlinkTime = 0;
const int interval = 500; // Blink speed in milliseconds

void setup() {
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop() {
  bool currentButtonState = digitalRead(buttonPin);

  // Check if button is pressed (transition from HIGH to LOW)
  if (currentButtonState == LOW && lastButtonState == HIGH) {
    isBlinking = !isBlinking; // Toggle the state
    
    // Print status to Serial Monitor
    Serial.print("LED Status: ");
    Serial.println(isBlinking ? "BLINKING" : "OFF");
    
    if (!isBlinking) digitalWrite(ledPin, LOW); // Ensure LED is off when disabled
    delay(50); // Debounce delay
  }
  lastButtonState = currentButtonState;

  // Handle the blinking without blocking the code
  if (isBlinking) {
    if (millis() - lastBlinkTime >= interval) {
      lastBlinkTime = millis();
      digitalWrite(ledPin, !digitalRead(ledPin)); // Invert current LED state
    }
  }
}